﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KursBeispiele
{
    public partial class KeineBitflag : Form
    {
        public KeineBitflag()
        {
            InitializeComponent();

            //Setzen den FormBorderStyle neu - hier Fixed (Größe kann nicht geändert werden)
            //und ToolWindows (kleinere Infoleiste)
            FormBorderStyle = FormBorderStyle.FixedToolWindow;

            //Zeigen das Formular nicht in der Taskleiste
            ShowInTaskbar = false;
        }

        //Straight Forward wie wir Enumerationen kennen - hier von 0 bis 9
        enum Beispiel
        {
            One,// = 1, //würde von 1 bis 10 gehen
            Two,
            Three,
            Four,
            Five,
            Six,
            Seven,
            Eight,
            Nine,
            Ten,
        }

        //Mal ausprobieren was passiert wenn das Ergebnis des Dialogs noch geändert wird beim Schließen
        private void KeineBitflag_FormClosing(object sender, FormClosingEventArgs e)
        {
            //Vorsicht: Wenn man DialogResult ändert ohne das das Formular geschlossen wird, hat dies
            //das Schließen des Formulars als Konsequenz - dies ist in der Eigenschaft so eingebaut...
            //Daher: Entweder DialogResult irgendwo merken und erst in FormClosing setzen oder DialogResult
            //nur ändern wenn das Formular damit auch geschlossen werden soll
            //DialogResult = DialogResult.OK;
        }

        private void KeineBitflag_Load(object sender, EventArgs e)
        {
            //Verwenden aus Performancegründen den StringBuilder
            StringBuilder sb = new StringBuilder();

            //Werte und Namen holen
            string[] names = Enum.GetNames(typeof(Beispiel));
            Array values = Enum.GetValues(typeof(Beispiel));

            //Chaining von StringBuilder ausnutzen
            for(int i = 0; i < values.Length; i++)
                sb.Append((int)values.GetValue(i)).Append("  (").Append(names[i]).AppendLine(")");

            //Text setzen
            textBox1.Text = sb.ToString();

            //Hier ausprobiern: Wird bei Nicht-Modal nicht angewendet - ansonsten wird Formular geschlossen
            //und zwar mit dem DialogResult.Ignore Ergebnis
            //DialogResult = DialogResult.Ignore;
        }
    }
}
